counts = {}
filename = "table_annotations_timecourse.txt"
stream = open(filename)
line = next(stream)
words = line.strip().split("\t")
assert words[0] == 'dataset'
datasets = words[1:]
for dataset in datasets:
    counts[dataset] = {}
line = next(stream)
words = line.strip().split("\t")
assert words[0] == 'library'
libraries = words[1:]
for dataset, library in zip(datasets, libraries):
    counts[dataset][library] = {}
line = next(stream)
words = line.strip().split("\t")
assert words[0] == 'condition'
timepoints = words[1:]
categories = []
for line in stream:
    words = line.strip().split("\t")
    category = words[0]
    categories.append(category)
    for dataset, library, count in zip(datasets, libraries, words[1:]):
        counts[dataset][library][category] = int(count)
stream.close()

filename = "TableS3.txt"
print("Writing %s" % filename)
stream = open(filename, "wt")
stream.write("Dataset")
for dataset in datasets:
    if dataset == "StartSeq":
        dataset = "Start-Seq"
    stream.write("\t" + dataset)
stream.write("\n")
stream.write("Single-/paired-end")
for dataset in datasets:
    if dataset == "StartSeq":
        stream.write("\tSingle-end")
    elif dataset == "MiSeq":
        stream.write("\tPaired-end")
    elif dataset == "HiSeq":
        stream.write("\tSingle-end")
    elif dataset == "CAGE":
        stream.write("\tSingle-end")
    else:
        raise Exception("Unknown dataset %s" % dataset)
stream.write("\n")
stream.write("Library")
for library in libraries:
    stream.write("\t" + library)
stream.write("\n")
stream.write("Time point")
for timepoint in timepoints:
    stream.write("\t" + timepoint)
stream.write("\n")
for category in categories:
    stream.write(category)
    for dataset, library in zip(datasets, libraries):
        count = counts[dataset][library][category]
        stream.write("\t%d" % count)
    stream.write("\n")
stream.close()
